/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Utils;
import weka.filters.unsupervised.attribute.StringToWordVector;

public class UtilsTest
extends TestCase {
    public UtilsTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSplittingAndJoining() {
        try {
            String[] options = new StringToWordVector().getOptions();
            String joined = Utils.joinOptions(options);
            String[] newOptions = Utils.splitOptions(joined);
            UtilsTest.assertEquals("Same number of options", options.length, newOptions.length);
            int i = 0;
            while (i < options.length) {
                if (!options[i].equals(newOptions[i])) {
                    UtilsTest.fail("Option " + (i + 1) + " differs");
                }
                ++i;
            }
        }
        catch (Exception e) {
            UtilsTest.fail("Exception: " + e);
        }
    }

    public void testQuoting() {
        String input = "blahblah";
        String output = Utils.quote(input);
        UtilsTest.assertTrue("No quoting necessary", !output.startsWith("'") && !output.endsWith("'"));
        input = "";
        output = Utils.quote(input);
        UtilsTest.assertTrue("Empty string quoted", output.startsWith("'") && output.endsWith("'"));
        UtilsTest.assertTrue("Empty string restored", input.equals(Utils.unquote(output)));
        input = " ";
        output = Utils.quote(input);
        UtilsTest.assertTrue("Blank quoted", output.startsWith("'") && output.endsWith("'"));
        UtilsTest.assertTrue("Blank restored", input.equals(Utils.unquote(output)));
        input = "{";
        output = Utils.quote(input);
        UtilsTest.assertTrue(">" + input + "< quoted", output.startsWith("'") && output.endsWith("'"));
        UtilsTest.assertTrue(">" + input + "< restored", input.equals(Utils.unquote(output)));
        input = "}";
        output = Utils.quote(input);
        UtilsTest.assertTrue(">" + input + "< quoted", output.startsWith("'") && output.endsWith("'"));
        UtilsTest.assertTrue(">" + input + "< restored", input.equals(Utils.unquote(output)));
        input = ",";
        output = Utils.quote(input);
        UtilsTest.assertTrue(">" + input + "< quoted", output.startsWith("'") && output.endsWith("'"));
        UtilsTest.assertTrue(">" + input + "< restored", input.equals(Utils.unquote(output)));
        input = "?";
        output = Utils.quote(input);
        UtilsTest.assertTrue(">" + input + "< quoted", output.startsWith("'") && output.endsWith("'"));
        UtilsTest.assertTrue(">" + input + "< restored", input.equals(Utils.unquote(output)));
        input = "\r\n\t'\"%";
        output = Utils.quote(input);
        UtilsTest.assertTrue(">" + input + "< quoted", output.startsWith("'") && output.endsWith("'"));
        UtilsTest.assertTrue(">" + input + "< restored", input.equals(Utils.unquote(output)));
    }

    public void testBackQuoting() {
        String input = "blahblah";
        String output = Utils.backQuoteChars(input);
        UtilsTest.assertTrue("No backquoting necessary", input.equals(output));
        input = "\r\n\t'\"%";
        output = Utils.backQuoteChars(input);
        UtilsTest.assertTrue(">" + input + "< restored", input.equals(Utils.unbackQuoteChars(output)));
        input = "\\r\\n\\t\\'\\\"\\%";
        output = Utils.backQuoteChars(input);
        UtilsTest.assertTrue(">" + input + "< restored", input.equals(Utils.unbackQuoteChars(output)));
        input = Utils.joinOptions(new StringToWordVector().getOptions());
        output = Utils.backQuoteChars(input);
        UtilsTest.assertTrue(">" + input + "< restored", input.equals(Utils.unbackQuoteChars(output)));
    }

    public static Test suite() {
        return new TestSuite(UtilsTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(UtilsTest.suite());
    }
}

